﻿namespace Microsoft.Samples.PlanMyNight.Web
{
    using System.Collections.Generic;
    using System.Linq;
    using System.Web.Mvc;
    using System.Web.Routing;
    using Microsoft.Samples.PlanMyNight.Entities;
    using Microsoft.Samples.PlanMyNight.Infrastructure;
    using Microsoft.Samples.PlanMyNight.Infrastructure.Mvc;
    using Microsoft.Samples.PlanMyNight.Web.Controllers;
    using Microsoft.Samples.PlanMyNight.Web.ViewModels;

    public static class ViewModelExtensions
    {
        public static ItineraryViewModel ToViewModel(this Controller controller, Itinerary itinerary)
        {
            if (itinerary == null)
            {
                return null;
            }

            var ids = string.Join("|", itinerary.Activities.Select(a => a.ActivityId).ToArray());
            var model = new ItineraryViewModel
            {
                Id = itinerary.Id,
                UserId = itinerary.UserId,
                Name = itinerary.Name,
                Created = itinerary.Created,
                Description = itinerary.Description,
                IsPublic = itinerary.IsPublic,
                Rating = itinerary.Rating ?? 0,
                EstimatedMinutes = itinerary.TotalEstimatedMinutes,
                ActivitiesCount = itinerary.Activities.Count,
                AddActivitiesLink = controller.BuildUrlFromExpression<ItinerariesController>(c => c.AddActivities(ids)),
                DetailsLink = controller.BuildUrlFromExpression<ItinerariesController>(c => c.Details(itinerary.Id)),
                Activities = itinerary.Activities.OrderBy(a => a.Order).Select(a => controller.ToViewModel(a)).Where(i => i != null).ToArray()
            };

            return model;
        }

        public static ItineraryDetailsViewModel ToViewModel(this Controller controller, Itinerary itinerary, string owner, bool canEdit, bool canRate)
        {
            if (itinerary == null)
            {
                return null;
            }

            var ids = string.Join("|", itinerary.Activities.Select(a => a.ActivityId).ToArray());
            var model = new ItineraryDetailsViewModel
            {
                Id = itinerary.Id,
                UserId = itinerary.UserId,
                Name = itinerary.Name,
                Created = itinerary.Created,
                Description = itinerary.Description,
                IsPublic = itinerary.IsPublic,
                Rating = itinerary.Rating ?? 0,
                CanEdit = canEdit,
                CanRate = canRate,
                Owner = owner,
                EstimatedMinutes = itinerary.TotalEstimatedMinutes,
                ActivitiesCount = itinerary.Activities.Count,
                AddActivitiesLink = controller.BuildUrlFromExpression<ItinerariesController>(c => c.AddActivities(ids)),
                DetailsLink = controller.BuildUrlFromExpression<ItinerariesController>(c => c.Details(itinerary.Id)),
                Activities = itinerary.Activities.OrderBy(a => a.Order).Select(a => controller.ToViewModel(a)).Where(i => i != null).ToArray()
            };

            // get addin links and toolboxes
            var addinBoxes = new List<RouteValueDictionary>();
            var addinLinks = new List<ExtensionLink>();

            addinBoxes.AddRange(AddinExtensions.GetActionsFor("ItineraryToolbox", model.Id == 0 ? null : new { id = model.Id }));
            addinLinks.AddRange(AddinExtensions.GetLinksFor("ItineraryLinks", model.Id == 0 ? null : new { id = model.Id }));

            if (model.IsPublic && model.Id != 0)
            {
                var routeValues = new
                {
                    id = model.Id,
                    title = model.Name,
                    url = controller.GetAbsoluteUrl(controller.BuildUrlFromExpression<ItinerariesController>(c => c.Details(model.Id)))
                };

                addinBoxes.AddRange(AddinExtensions.GetActionsFor("SharingToolbox", routeValues));
                addinLinks.AddRange(AddinExtensions.GetLinksFor("SharingLinks", routeValues));
            }

            model.AddinBoxes = addinBoxes;
            model.AddinLinks = addinLinks;

            return model;
        }

        public static ActivityViewModel ToViewModel(this Controller controller, Activity activity)
        {
            return new ActivityViewModel
            {
                Entity = activity,
                DetailsLink = "http://www.bing.com/local/details.aspx?lid=" + activity.BingId,
                AddToItineraryLink = controller.BuildUrlFromExpression<ItinerariesController>(c => c.AddActivity(activity.Id, null)),
                ActivityItinerariesLink = controller.BuildUrlFromExpression<SearchController>(c => c.ByActivity(activity.Id, 1))
            };
        }

        public static ActivityViewModel ToViewModel(this Controller controller, ItineraryActivity activity)
        {
            if (activity.Activity == null)
            {
                return null;
            }

            var urlHelper = controller.Url;

            var model = controller.ToViewModel(activity.Activity);
            model.RemoveFromItineraryLink = controller.BuildUrlFromExpression<ItinerariesController>(c => c.DeleteActivity(activity.Activity.Id));
            model.SetEstimatedTimeLink = controller.Url.Action("SetEstimatedTime", "Itineraries", new { activityId = activity.Activity.Id });
            model.EstimatedMinutes = activity.EstimatedMinutes;
            model.MoveDownInItineraryLink = controller.BuildUrlFromExpression<ItinerariesController>(c => c.MoveActivity(activity.Activity.Id, activity.Order + 1));
            model.MoveUpInItineraryLink = controller.BuildUrlFromExpression<ItinerariesController>(c => c.MoveActivity(activity.Activity.Id, activity.Order - 1));
            return model;
        }
    }
}
